/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.TextColor;
import shadows.gateways.Gateways;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Failure;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.SpawnAlgorithms;
import shadows.gateways.gate.Wave;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.TypeKeyed;

public class Gateway
extends TypeKeyed.TypeKeyedBase<Gateway> {
    public static Codec<Gateway> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GatewayEntity.GatewaySize.CODEC.fieldOf("size").forGetter(Gateway::getSize), (App)TextColor.f_237295_.fieldOf("color").forGetter(Gateway::getColor), (App)Wave.CODEC.listOf().fieldOf("waves").forGetter(Gateway::getWaves), (App)Reward.CODEC.listOf().optionalFieldOf("rewards", Collections.emptyList()).forGetter(Gateway::getRewards), (App)Failure.CODEC.listOf().optionalFieldOf("failures", Collections.emptyList()).forGetter(Gateway::getFailures), (App)Codec.INT.fieldOf("completion_xp").forGetter(Gateway::getCompletionXp), (App)Codec.DOUBLE.fieldOf("spawn_range").forGetter(Gateway::getSpawnRange), (App)Codec.DOUBLE.optionalFieldOf("leash_range", (Object)32.0).forGetter(g -> g.leashRange), (App)SpawnAlgorithms.CODEC.optionalFieldOf("spawn_algorithm", (Object)((SpawnAlgorithms.SpawnAlgorithm)SpawnAlgorithms.NAMED_ALGORITHMS.get((Object)Gateways.loc("open_field")))).forGetter(g -> g.spawnAlgo), (App)Codec.BOOL.optionalFieldOf("player_damage_only", (Object)false).forGetter(g -> g.playerDamageOnly), (App)Codec.BOOL.optionalFieldOf("allow_discarding", (Object)false).forGetter(g -> g.allowDiscarding), (App)Codec.BOOL.optionalFieldOf("remove_mobs_on_failure", (Object)true).forGetter(g -> g.removeMobsOnFailure)).apply((Applicative)inst, Gateway::new));
    public static final PSerializer<Gateway> SERIALIZER = PSerializer.fromCodec((String)"Gateway", CODEC);
    protected final GatewayEntity.GatewaySize size;
    protected final TextColor color;
    protected final List<Wave> waves;
    protected final List<Reward> rewards;
    protected final List<Failure> failures;
    protected final int completionXp;
    protected final double spawnRange;
    protected final double leashRange;
    protected final SpawnAlgorithms.SpawnAlgorithm spawnAlgo;
    protected final boolean playerDamageOnly;
    protected final boolean allowDiscarding;
    protected final boolean removeMobsOnFailure;

    public Gateway(GatewayEntity.GatewaySize size, TextColor color, List<Wave> waves, List<Reward> rewards, List<Failure> failures, int completionXp, double spawnRange, double leashRange, SpawnAlgorithms.SpawnAlgorithm spawnAlgo, boolean onlyPlayerDamage, boolean allowDiscarding, boolean removeMobsOnFailure) {
        this.size = size;
        this.color = color;
        this.waves = waves;
        this.rewards = rewards;
        this.failures = failures;
        this.completionXp = completionXp;
        this.spawnRange = spawnRange;
        this.leashRange = leashRange;
        this.spawnAlgo = spawnAlgo;
        this.playerDamageOnly = onlyPlayerDamage;
        this.allowDiscarding = allowDiscarding;
        this.removeMobsOnFailure = removeMobsOnFailure;
    }

    public GatewayEntity.GatewaySize getSize() {
        return this.size;
    }

    public TextColor getColor() {
        return this.color;
    }

    public List<Wave> getWaves() {
        return this.waves;
    }

    public int getNumWaves() {
        return this.waves.size();
    }

    public Wave getWave(int n) {
        return this.waves.get(n);
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public int getCompletionXp() {
        return this.completionXp;
    }

    public double getSpawnRange() {
        return this.spawnRange;
    }

    public double getLeashRangeSq() {
        return this.leashRange * this.leashRange;
    }

    public SpawnAlgorithms.SpawnAlgorithm getSpawnAlgo() {
        return this.spawnAlgo;
    }

    public boolean playerDamageOnly() {
        return this.playerDamageOnly;
    }

    public boolean allowsDiscarding() {
        return this.allowDiscarding;
    }

    public boolean removeMobsOnFailure() {
        return this.removeMobsOnFailure;
    }

    public PSerializer<? extends Gateway> getSerializer() {
        return SERIALIZER;
    }
}

